#pragma once

#include <GR/GRTypes.h>

#include <map>
#include "BTypes.h"
#include "EnemyInfo.h"


class Unit;
class Level;
class Collectible;
class Birdie;
class Points;

namespace GameLogic
{
  extern std::map<Birdie2::eUnitTypes, Birdie2::EnemyInfo>      EnemyInfos;


  GR::u32   UnitsCollide( Unit* pUnit1, Unit* pUnit2, Level& Level );
  void      ItemCollected( Birdie* pPlayer, Collectible* pItem, Level& Level );

  bool      CanUnitStandOnPlatform( Unit& Unit );

  Unit*     SpawnBonus( const GR::tPoint& Pos, const std::string& CaughtImage );
  Unit*     SpawnExtra( Level& Level, const GR::tPoint& Pos );

  Points*   SpawnPoints( Level& Level, int X, int Y, int Value );

};
