#ifndef GSOPTIONS_H
#define GSOPTIONS_H

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <Xtreme/XRenderer.h>

#include <GR\GameState\GUIGameState.h>

#include <Controls\OutputEvent.h>

#include <Interface/ICloneAble.h>

#include <Misc/CloneFactory.h>

#include "FallingMenu.h"



class CGSOptions : public GUIGameState<XRenderer>, public EventListener<GUI::OutputEvent>
{

  public:

    DECLARE_CLONEABLE( CGSOptions, "GSOptions" )


    FallingMenu             m_Menu;
    bool                    m_WaitForKey;
    int                     m_MenuWaitingForKey;



    virtual void            Init();
    virtual void            Exit();


    virtual void            UpdatePerDisplayFrame( const float fElapsedTime );
    virtual void            Display( XRenderer& Viewer );
    virtual void            Update();

    virtual bool            ProcessEvent( const GUI::OutputEvent& Event );

    void                    OnMenuHandler( FallingMenu::MenuEntryAction Action, const FallingMenu::tMenuEntry& Entry );
    void                    UpdateMenuItemForKey( int ItemID );

};

#endif // GSOPTIONS_H
