#include "GSOptions.h"
#include "BirdiesRevenge.h"
#include "BTypes.h"

#include <String/StringUtil.h>



IMPLEMENT_CLONEABLE( CGSOptions, "GSOptions" )



void CGSOptions::Init()
{
  m_WaitForKey        = false;
  m_MenuWaitingForKey = 0;

  m_Menu.Add( 3, "", Birdie2::ControlKey::LEFT );
  m_Menu.Add( 4, "", Birdie2::ControlKey::RIGHT );
  m_Menu.Add( 5, "", Birdie2::ControlKey::JUMP );
  m_Menu.Add( 6, "", Birdie2::ControlKey::ACTION );
  
  m_Menu.Add( 7 );
  m_Menu.Add( 8 );

  m_Menu.SetItemLeftRightActive( 7, true );
  m_Menu.SetItemLeftRightActive( 8, true );

  if ( m_paramInit.HasParam( "InGame" ) )
  {
    m_Menu.Add( 9 );
    m_Menu.Add( 10 );
  }
  else
  {
    m_Menu.Add( 11 );
  }

  UpdateMenuItemForKey( 3 );
  UpdateMenuItemForKey( 4 );
  UpdateMenuItemForKey( 5 );
  UpdateMenuItemForKey( 6 );

  m_Menu.SetMenuHandler( fastdelegate::MakeDelegate( this, &CGSOptions::OnMenuHandler ) );
  m_Menu.SetValues( GR::tPoint( 400, 300 ), GR::tPoint( 700, 0 ) );
}



void CGSOptions::Exit()
{
}



void CGSOptions::UpdateMenuItemForKey( int ItemID )
{
  GR::Database::Table*    pTable = theApp.m_TextDB.GetTable( "GUI" );
  std::string             keyName = GR::Strings::ToUpper( theApp.InputClass()->GetKeyName( theApp.BoundKey( m_Menu.GetItemParamByID( ItemID ) ) ) );

  m_Menu.SetItemText( ItemID, pTable->Entry( ItemID ) + ": " + keyName );
}



void CGSOptions::OnMenuHandler( FallingMenu::MenuEntryAction Action, const FallingMenu::tMenuEntry& Entry )
{
  switch ( Action )
  {
    case FallingMenu::MEA_LEFT_PRESSED:
      switch ( Entry.TextID )
      {
        case 7:
          {
            int     fxVolume = theApp.GetVarI( "FX.Volume" );
            fxVolume = math::maxValue( fxVolume - 10, 0 );

            theApp.SetVarI( "FX.Volume", fxVolume );

            m_Menu.UpdateItemText( 7 );
          }
          break;
        case 8:
          {
            int     musicVolume = theApp.GetVarI( "Music.Volume" );
            musicVolume = math::maxValue( musicVolume - 10, 0 );

            theApp.SetVarI( "Music.Volume", musicVolume );

            m_Menu.UpdateItemText( 8 );
          }
          break;
      }
      break;
    case FallingMenu::MEA_RIGHT_PRESSED:
      switch ( Entry.TextID )
      {
        case 7:
          {
            int     fxVolume = theApp.GetVarI( "FX.Volume" );
            fxVolume = math::minValue( fxVolume + 10, 100 );

            theApp.SetVarI( "FX.Volume", fxVolume );

            m_Menu.UpdateItemText( 7 );
          }
          break;
        case 8:
          {
            int     musicVolume = theApp.GetVarI( "Music.Volume" );
            musicVolume = math::minValue( musicVolume + 10, 100 );

            theApp.SetVarI( "Music.Volume", musicVolume );

            m_Menu.UpdateItemText( 8 );
          }
          break;
      }
      break;
  }
}



void CGSOptions::Display( XRenderer& Renderer )
{
  m_Menu.Display( Renderer );
}



void CGSOptions::UpdatePerDisplayFrame( const float ElapsedTime )
{
  if ( m_WaitForKey )
  {
    GR::u32     pressedKey = theApp.InputClass()->PressedVKey();
    if ( ( pressedKey != 0 )
    &&   ( theApp.InputClass()->ReleasedVKeyPressed( pressedKey ) ) )
    {
      theApp.SetKeyBinding( m_MenuWaitingForKey - 3, pressedKey );
      UpdateMenuItemForKey( m_MenuWaitingForKey );
      m_WaitForKey = false;
    }
    return;
  }

  m_Menu.Update( ElapsedTime );
  if ( m_Menu.Done() )
  {
    m_Menu.SetUndone();
    switch ( m_Menu.SelectedItem() )
    {
      case 3:
      case 4:
      case 5:
      case 6:
        {
          GR::Database::Table*    pTable = theApp.m_TextDB.GetTable( "GUI" );

          m_Menu.SetItemText( m_Menu.SelectedItem(), pTable->Entry( m_Menu.SelectedItem() ) + ": " + pTable->Entry( 12 ) );

          m_WaitForKey = true;
          m_MenuWaitingForKey = m_Menu.SelectedItem();
        }
        break;
      case 7:
        // FX Volume
        {
          int     fxVolume = theApp.GetVarI( "FX.Volume" );
          fxVolume = ( fxVolume + 10 );
          fxVolume -= fxVolume % 10;
          if ( fxVolume > 100 )
          {
            fxVolume = 0;
          }

          theApp.SetVarI( "FX.Volume", fxVolume );

          m_Menu.UpdateItemText( 7 );
        }
        break;
      case 8:
        // Music Volume
        {
          int     musicVolume = theApp.GetVarI( "Music.Volume" );
          musicVolume = ( musicVolume + 10 );
          musicVolume -= musicVolume % 10;
          if ( musicVolume > 100 )
          {
            musicVolume = 0;
          }

          theApp.SetVarI( "Music.Volume", musicVolume );

          m_Menu.UpdateItemText( 8 );
        }
        break;
      case 9:
        // resume
      case 11:
        // back to main menu
        PopState();
        break;
      case 10:
        // quit game
        PopState();
        GLOBAL_QUEUE.PostEvent( "App.ChangeState", "GSMenu" );
        break;
    }
  }
  if ( theApp.InputClass()->ReleasedKeyPressed( Xtreme::KEY_ESCAPE ) )
  {
    PopState();
  }
}



void CGSOptions::Update()
{

  // TODO - Update

}



bool CGSOptions::ProcessEvent( const GUI::OutputEvent& Event )
{
  switch ( Event.Type )
  {
    case OET_BUTTON_PUSHED:
      break;
  }
  return false;
}
