#include "GSMenu.h"
#include "BirdiesRevenge.h"



IMPLEMENT_CLONEABLE( CGSMenu, "GSMenu" )



void CGSMenu::Init()
{
  theApp.PlaySong( "ingame" );

  m_Menu.Add( 0 );
  m_Menu.Add( 1 );
  m_Menu.Add( 13 );
  m_Menu.Add( 2 );

  m_Menu.SetValues( GR::tPoint( 400, 400 ) );
}



void CGSMenu::Exit()
{

    // TODO - GUIScreen entfernen
  
}



void CGSMenu::Display( XRenderer& Renderer )
{
  theApp.RenderBackground( Renderer, "BG.2" );

  Renderer.SetShader( XRenderer::ST_ALPHA_TEST );
  Renderer.RenderTextureSection2d( ( 800 - ( 256 + 126 ) ) / 2, 100, theApp.Section( "Title.1" ) );
  Renderer.RenderTextureSection2d( ( 800 - ( 256 + 126 ) ) / 2 + 256, 100, theApp.Section( "Title.2" ) );

  m_Menu.Display( Renderer );
}



void CGSMenu::UpdatePerDisplayFrame( const float ElapsedTime )
{
  if ( !IsActivelyUpdating() )
  {
    return;
  }
  m_Menu.Update( ElapsedTime );
  if ( m_Menu.Done() )
  {
    m_Menu.SetUndone();
    switch ( m_Menu.SelectedItem() )
    {
      case 0:
        ChangeState( "GSGame" );
        break;
      case 1:
        PushState( "GSOptions" );
        break;
      case 2:
        GLOBAL_QUEUE.PostEvent( "App.ShutDown" );
        break;
      case 13:
        ChangeState( "GSCredits" );
        break;
    }
  }
  if ( theApp.InputClass()->ReleasedKeyPressed( Xtreme::KEY_ESCAPE ) )
  {
    GLOBAL_QUEUE.PostEvent( "App.ShutDown" );
  }
  if ( theApp.InputClass()->ReleasedKeyPressed( Xtreme::KEY_P ) )
  {
    ChangeState( "GSGame" );
  }
  if ( theApp.InputClass()->ReleasedKeyPressed( Xtreme::KEY_E ) )
  {
    ChangeState( "GSEdit" );
  }
}



void CGSMenu::Update()
{

  // TODO - Update

}



bool CGSMenu::ProcessEvent( const GUI::OutputEvent& Event )
{
  switch ( Event.Type )
  {
    case OET_BUTTON_PUSHED:
      break;
  }
  return false;
}
