#ifndef GSGame_H
#define GSGame_H

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <Xtreme/XRenderer.h>

#include <GR\GameState\GUIGameState.h>

#include <Controls\OutputEvent.h>

#include <Interface/ICloneAble.h>

#include <Misc/CloneFactory.h>

#include "Level.h"



namespace Birdie2
{
  struct CGameEvent;
};


class CGSGame : public GUIGameState<XRenderer>, public EventListener<GUI::OutputEvent>
{

  public:

    DECLARE_CLONEABLE( CGSGame, "GSGame" )


    Level                   m_Level;

    GR::u32                 m_dwLevel;

    GR::u32                 m_dwScore;

    bool                    m_DiamondsCollected[7];

    Unit*                   m_pBossUnit;
    int                     m_BossMaxHealth;

    int                     m_NumLives;



    virtual void            Init();
    virtual void            Exit();


    virtual void            UpdatePerDisplayFrame( const float fElapsedTime );
    virtual void            Display( XRenderer& Viewer );
    virtual void            Update();

    virtual bool            ProcessEvent( const GUI::OutputEvent& Event );

    void                    ProcessGameEvent( const Birdie2::CGameEvent& GameEvent );

    void                    StartLevel();

};

#endif // GSGame_H
