#ifndef GSEdit_H
#define GSEdit_H

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <Xtreme/XRenderer.h>

#include <GR\GameState\GUIGameState.h>

#include <Controls\OutputEvent.h>

#include <Interface/ICloneAble.h>

#include <Misc/CloneFactory.h>

#include "Level.h"



class GUIEdit;
class GUIScreen;

class CGSEdit : public GUIGameState<XRenderer>, public EventListener<GUI::OutputEvent>
{

  public:

    DECLARE_CLONEABLE( CGSEdit, "GSEdit" )


    enum EditMode
    {
      EM_TILES,
      EM_MONSTER,
      EM_EXTRA_POS,
      EM_BUBBLE_TARGET_POS,
      EM_FLASH_START_POS,
      EM_LAST_ENTRY
    };


    Level                  m_Level;

    GR::u32                 m_dwCurLevel;

    Birdie2::eFeldTypes     m_curFeld;

    Birdie2::eUnitTypes     m_curUnit;

    Unit*                   m_pSelectedUnit;

    EditMode                m_EditMode;

    //GUIEdit*                m_pEditWidth;
    //GUIEdit*                m_pEditHeight;

    //GUIScreen*              m_pScreen;


    virtual void            Init();
    virtual void            Exit();


    virtual void            UpdatePerDisplayFrame( const float fElapsedTime );
    virtual void            Display( XRenderer& Viewer );
    virtual void            Update();

    virtual bool            ProcessEvent( const GUI::OutputEvent& Event );

    void                    OnApplySize( const GUI::OutputEvent& Event );

};

#endif // GSEdit_H
