#include <Xtreme/XRenderer.h>

#include <cmath>

#include ".\BirdiesRevenge.h"
#include ".\FlashBubble.h"
#include ".\Level.h"



FlashBubble::FlashBubble()
{
  m_Type = Birdie2::UT_FLASH_BUBBLE;

  m_ArrivedOnTop = false;

  m_TimeToPop = 0.0f;

  m_MovedDistance = 0.0f;

  m_MovementBounds.set( 12, 12, 40, 40 );
  m_CollisionBounds.set( 12, 12, 40, 40 );

  m_Floating = true;

  SetAnimation( "Flash.Bubble" );
}



void FlashBubble::Update( Level& Level, const GR::f32 ElapsedTime )
{
  GR::tFPoint   ptCurPos( 400.0f, 52.0f );

  m_TimeToPop += ElapsedTime;
  if ( m_TimeToPop >= 20.0f )
  {
    m_RemoveMe = true;

    Unit*    pPop = Unit::FromType( Birdie2::UT_POP );
    pPop->m_Position = m_Position;
    pPop->m_Position.offset( 12, 12 );

    Level.m_Units.push_back( pPop );
  }

  Unit::Update( Level, ElapsedTime );
}



void FlashBubble::UpdateFixed( Level& Level )
{
  if ( !m_ArrivedOnTop )
  {
    GR::tPoint    ptTarget( Level.m_BubbleTargetPos );

    GR::tPoint    ptPos( m_Position );

    GR::tPoint    delta( ptTarget - m_Position );

    // go y first
    if ( delta.y != 0 )
    {
      delta.y = math::clamp( delta.y, -1, 1 );

      MoveUnblocked( Level, 0, delta.y );
    }
    else if ( delta.x != 0 )
    {
      delta.x = math::clamp( delta.x, -1, 1 );

      MoveUnblocked( Level, delta.x, 0 );
    }
    else
    {
      m_ArrivedOnTop = true;
    }
  }
  Unit::UpdateFixed( Level );
}



void FlashBubble::ProcessEvent( Level& Level, const eUnitEvent& Event )
{
  Unit::ProcessEvent( Level, Event );

  switch ( Event )
  {
    case ET_BLOCKED_LEFT:
      break;
    case ET_BLOCKED_RIGHT:
      break;
    case ET_FALL_START:
      break;
    case ET_FALL_END:
      break;
  }
}