#include <Xtreme/XRenderer.h>

#include <cmath>

#include ".\BirdiesRevenge.h"
#include ".\Flash.h"
#include ".\Level.h"



Flash::Flash()
{
  m_Type = Birdie2::UT_FLASH;

  m_MovementBounds.set( 12, 12, 40, 40 );
  m_CollisionBounds.set( 12, 12, 40, 40 );

  m_Floating = true;
  m_NoAutoAdjustFacing = true;

  SetImage( "Flash" );
}



void Flash::Update( Level& Level, const GR::f32 fElapsedTime )
{
  if ( ( m_Position.x < -40 )
  ||   ( m_Position.x >= 800 ) )
  {
    m_RemoveMe = true;
  }
}



void Flash::UpdateFixed( Level& Level )
{
  if ( m_FaceLeft )
  {
    MoveUnblocked( Level, -10, 0 );
  }
  else
  {
    MoveUnblocked( Level, 10, 0 );
  }
}



void Flash::ProcessEvent( Level& Level, const eUnitEvent& Event )
{
  Unit::ProcessEvent( Level, Event );

  switch ( Event )
  {
    case ET_BLOCKED_LEFT:
      break;
    case ET_BLOCKED_RIGHT:
      break;
    case ET_FALL_START:
      break;
    case ET_FALL_END:
      break;
  }
}