#include <Xtreme/XRenderer.h>

#include ".\BirdiesRevenge.h"
#include ".\BossShot.h"
#include ".\Level.h"



BossShot::BossShot()
{
  m_Type = Birdie2::UT_BOSS_SHOT;

  m_MovementBounds.set( 8, 9, 26, 26 );
  m_CollisionBounds.set( 8, 9, 26, 26 );

  m_Floating = true;
  m_CoordinatesWrapAround = false;

  SetImage( "Boss.Shot" );
}



void BossShot::UpdateFixed( Level& Level )
{
  if ( ( m_Position.x < -40 )
  ||   ( m_Position.y < -40 )
  ||   ( m_Position.x >= 840 )
  ||   ( m_Position.y >= 640 ) )
  {
    m_RemoveMe = true;
  }
  Unit::UpdateFixed( Level );
}



void BossShot::Update( Level& Level, const GR::f32 fElapsedTime )
{
  Unit::Update( Level, fElapsedTime );
}



void BossShot::ProcessEvent( Level& Level, const eUnitEvent& Event )
{
  Unit::ProcessEvent( Level, Event );

  switch ( Event )
  {
    case ET_BLOCKED_LEFT:
      break;
    case ET_BLOCKED_RIGHT:
      break;
    case ET_BLOCKED_UP:
      break;
    case ET_FALL_START:
      break;
    case ET_FALL_END:
      break;
  }

}



