#ifndef BirdiesRevenge_H_INCLUDED
#define BirdiesRevenge_H_INCLUDED

#include <Xtreme/XRenderer.h>
#include <Xtreme/XFont.h>
#include <Xtreme/XTexture.h>
#include <Xtreme/XVertexBuffer.h>

#include <windows.h>

#include <vector>
#include <list>

#include <GR/GameState/GUIGameState.h>

#include <Controls/Xtreme/GUIComponentDisplayer.h>

#include <Interface/IEventListener.h>

#include <MasterFrame/XFrameApp.h>

#include "resource.h"



class BirdiesRevenge : public CXFrameApp
{
  public:

    std::string         m_ActiveSong;
    std::string         m_NextSong;
    bool                m_MusicFadeOut;
    bool                m_MusicFadeIn;

    GR::f32             m_TempVolume;



    BirdiesRevenge();
    virtual ~BirdiesRevenge();


    bool                ProcessEvent( const GUI::OutputEvent& Event );


    // MasterFrame-spezifisch
    virtual bool        InitInstance();
    virtual void        ExitInstance();
    virtual void        UpdatePerDisplayFrame( const float fElapsedTime );
    virtual void        UpdateFixedLogic();

    virtual bool        ProcessEvent( const GR::Gamebase::tXFrameEvent& Event );

    void PrintText( int X, int Y, const std::string& Text );
    void PrintTextCentered( int X, int Y, const std::string& Text );

    void PlaySong( const std::string& Song );

    void RenderBackground( XRenderer& Renderer, const std::string& Image );

};


extern BirdiesRevenge          theApp;



#endif // BirdiesRevenge_H_INCLUDED
