#include <Xtreme/XRenderer.h>

#include ".\BirdiesRevenge.h"
#include ".\Bird.h"



Bird::Bird()
{
  m_Type = Birdie2::UT_BIRD;

  m_Up = true;
  m_IsNasty = true;

  m_Floating = true;

  m_WalkSpeed = 3;

  m_MovementBounds.set( 0, 0, 40, 40 );
  m_CollisionBounds.set( 5, 5, 30, 30 );

  SetAnimation( "Bird.Fly" );
}



void Bird::Update( Level& Level, const GR::f32 fElapsedTime )
{
  if ( m_FaceLeft )
  {
    m_Speed.x = -m_WalkSpeed;
  }
  else
  {
    m_Speed.x = m_WalkSpeed;
  }
  if ( m_Up )
  {
    m_Speed.y = -m_WalkSpeed;
  }
  else
  {
    m_Speed.y = m_WalkSpeed;
  }
  Unit::Update( Level, fElapsedTime );
}



void Bird::ProcessEvent( Level& Level, const eUnitEvent& Event )
{
  Unit::ProcessEvent( Level, Event );

  switch ( Event )
  {
    case ET_BLOCKED_LEFT:
      m_FaceLeft = false;
      break;
    case ET_BLOCKED_RIGHT:
      m_FaceLeft = true;
      break;
    case ET_BLOCKED_UP:
      m_Up = false;
      break;
    case ET_BLOCKED_DOWN:
      m_Up = true;
      break;
    case ET_FALL_START:
      break;
    case ET_FALL_END:
      break;
  }
}