#include <Xtreme/XRenderer.h>

#include ".\BirdiesRevenge.h"
#include ".\Bat.h"



Bat::Bat()
{
  m_Type = Birdie2::UT_BAT;

  m_Up = true;
  m_IsNasty = true;

  m_Floating = true;

  m_WalkSpeed = 3;

  m_MovementBounds.set( 0, 0, 64, 40 );
  m_CollisionBounds.set( 10, 10, 44, 20 );

  SetAnimation( "Bat.Fly" );
}



void Bat::Update( Level& Level, const GR::f32 fElapsedTime )
{
  /*
  if ( m_bFaceLeft )
  {
    m_ptSpeed.x = -m_fWalkSpeed;
  }
  else
  {
    m_ptSpeed.x = m_fWalkSpeed;
  }
  */
  if ( m_Up )
  {
    m_Speed.y = -m_WalkSpeed;
  }
  else
  {
    m_Speed.y = m_WalkSpeed;
  }
  Unit::Update( Level, fElapsedTime );
}



void Bat::ProcessEvent( Level& Level, const eUnitEvent& Event )
{
  Unit::ProcessEvent( Level, Event );

  switch ( Event )
  {
    case ET_BLOCKED_LEFT:
      //m_bFaceLeft = false;
      break;
    case ET_BLOCKED_RIGHT:
      //m_bFaceLeft = true;
      break;
    case ET_BLOCKED_UP:
      m_Up = false;
      break;
    case ET_BLOCKED_DOWN:
      m_Up = true;
      break;
    case ET_FALL_START:
      break;
    case ET_FALL_END:
      break;
  }
}