#ifndef BIRDIE2_TYPES_H
#define BIRDIE2_TYPES_H



class Unit;

namespace Birdie2
{
  namespace ControlKey
  {
    enum Value
    {
      LEFT = 0,
      RIGHT,
      JUMP,
      ACTION
    };
  };

  enum eFeldTypes
  {
    FT_EMPTY = 0,
    FT_WALL,

    FT_SOLID,
    FT_PLATFORM_1,
    FT_PLATFORM_2,
    FT_PLATFORM_3,
    FT_PLATFORM_4,

    FT_BORDER_1,
    FT_BORDER_2,
    FT_BORDER_3,
    FT_BORDER_4,
    FT_BORDER_5,
    FT_BORDER_6,

    FT_LAST_ENTRY,

    FT_FORCE_DWORD = 0xffffffff,
  };

  enum eUnitTypes
  {
    UT_INVALID = -1,
    UT_BIRDIE = 0,
    UT_AUFZIEH,
    UT_NOTE,
    UT_BUBBLE,
    UT_POP,
    UT_BONUS,
    UT_BIRD,
    UT_BAT,
    UT_COLLECTIBLE,
    UT_POINTS,
    UT_THING,
    UT_FLASH,
    UT_FLASH_BUBBLE,
    UT_PUMPKIN,
    UT_BOSS_SHOT,
    UT_PUMPKIN_PIECE,

    UT_LAST_ENTRY
  };

  enum eItems
  {
    IT_INVALID = -1,
    IT_GUN,
    IT_UZI,
    IT_LAMP_1,
    IT_LAMP_2,
    IT_LAMP_3,

    IT_LAST_ENTRY
  };

  enum eDir
  {
    DIR_NONE = 0,
    DIR_N,
    DIR_S,
    DIR_W,
    DIR_E
  };

  struct CGameEvent
  {
    enum eEventType
    {
      GE_INVALID,
      GE_CHANGE_SCORE,
      GE_LEVEL_COMPLETED,
      GE_PLAYER_DIED,
      GE_ITEM_COLLECTED,
      GE_UNIT_DELETED
    };

    eEventType      m_Type;
    GR::i32         m_iParam[2];
    GR::String      m_strParam;
    Unit*           pUnit;

    CGameEvent( const eEventType Type, Unit* pUnit ) :
      m_Type( Type ),
      pUnit( pUnit )
    {
      m_iParam[0] = 0;
      m_iParam[1] = 0;
    }

    CGameEvent( const eEventType Type = GE_INVALID, const GR::i32 iParam1 = 0, const GR::i32 iParam2 = 0 ) :
      m_Type( Type ),
      pUnit( NULL )
    {
      m_iParam[0] = iParam1;
      m_iParam[1] = iParam2;
    }

    CGameEvent( const eEventType Type, const GR::String& strParam, const GR::i32 iParam1 = 0, const GR::i32 iParam2 = 0 ) :
      m_Type( Type ),
      m_strParam( strParam ),
      pUnit( NULL )
    {
      m_iParam[0] = iParam1;
      m_iParam[1] = iParam2;
    }

  };

  enum eStateFlags
  {
    SF_HAS_GUN        = 0x00000001,
  };

  struct tPlayerState
  {
    GR::u32         m_Flags;

    tPlayerState() :
      m_Flags( 0 )
    {
    }
  };

};


#endif // BIRDIE2_TYPES_H