#include <Xtreme/XRenderer.h>

#include ".\BirdiesRevenge.h"
#include ".\aufzieh.h"



Aufzieh::Aufzieh()
{
  m_Type = Birdie2::UT_AUFZIEH;

  m_MovementBounds.set( 0, 0, 40, 40 );
  m_CollisionBounds.set( 5, 5, 30, 30 );

  m_WalkSpeed = 2;
  m_IsNasty = true;

  m_fJumpDelay = 0.0f;

  SetAnimation( "Aufzieh.Walk" );
}



void Aufzieh::UpdateFixed( Level& Level )
{
  if ( m_fJumpDelay > 0.0f )
  {
    ++m_JumpAnimPos;
    if ( ( m_JumpAnimPos % 4 ) == 0 )
    {
      m_FaceLeft = !m_FaceLeft;
    }
  }

  Unit::UpdateFixed( Level );
}



void Aufzieh::Update( Level& Level, const GR::f32 fElapsedTime )
{
  if ( m_OnGround )
  {
    if ( m_fJumpDelay > 0.0f )
    {
      m_fJumpDelay -= fElapsedTime;
      if ( m_fJumpDelay <= 0.0f )
      {
        m_fJumpDelay = 0.0f;
        Jump( 16 );
        m_FaceLeft = m_OrigFacingDir;
      }
    }
    else
    {
      if ( m_FaceLeft )
      {
        m_Speed.x = -m_WalkSpeed;
      }
      else
      {
        m_Speed.x = m_WalkSpeed;
      }
    }
  }
  else
  {
    m_Speed.x = 0;
  }

  if ( m_fJumpDelay == 0.0f )
  {
    Unit::Update( Level, fElapsedTime );
  }

  if ( ( m_OnGround )
  &&   ( ( rand() % 800 ) == 1 ) )
  {
    m_fJumpDelay = 2.0f;
    m_Speed.x = 0;
    m_OrigFacingDir = m_FaceLeft;
  }
}



void Aufzieh::ProcessEvent( Level& Level, const eUnitEvent& Event )
{
  Unit::ProcessEvent( Level, Event );

  switch ( Event )
  {
    case ET_BLOCKED_LEFT:
      m_FaceLeft = false;
      break;
    case ET_BLOCKED_RIGHT:
      m_FaceLeft = true;
      break;
    case ET_FALL_START:
      break;
    case ET_FALL_END:
      break;
    case ET_GET_CAUGHT:
      m_fJumpDelay = 0.0f;
      m_JumpAnimPos = 0;
      break;
  }
}